﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Waluty" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Core" %>
<script runat="server">

    class Total {
        readonly string opis;
        public Total(string opis) {
            this.opis = opis;
        }
        public string Opis {
            get { return opis; }
        }
        public decimal Należność  {
            get { return 0m; }
        }
        public decimal Zobowiązanie {
            get { return 0m; }
        }
    }
    
    class WgWaluty {
        readonly string symbol;
        public WgWaluty(string symbol) {
            this.symbol = symbol;
        }
        public string Symbol {
            get { return symbol; }
        }
        public IEnumerable Pozycje {
            get { return new object[] {}; }
        }
        public IEnumerable Podsumowanie {
            get {
                return new object[] {
                    new Total("<b>Razem:</b>"),
                    new Total("<b>Saldo:</b>")
                };
            }
        }
    }
    
    ActualDate current;
    [Context]
    public ActualDate Current {
        set { current = value; }
    }
    
    void OnContextLoad(Object sender, EventArgs args) {
        object[] lista = new object[] { new WgWaluty("PLN")};
    
        ReportHeader1["DATA"] = current.Actual.ToString();
        ReportHeader2["DATA"] = current.Actual.ToString();
        data1.EditValue = current.Actual;
        data2.EditValue = current.Actual;
    
        DataRepeater1.DataSource = lista;
        DataRepeater2.DataSource = lista;
    }
    
</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Potwierdzenie salda</title> 
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form id="PotwierdzenieSalda" method="post" runat="server">
        <ea:datacontext id="dc" runat="server" TypeName="Soneta.CRM.Kontrahent,Soneta.CRM" oncontextload="OnContextLoad"></ea:datacontext>
        <ea:SectionMarker id="SectionMarker2" runat="server"></ea:SectionMarker>
        <cc1:reportheader id="ReportHeader1" title="Potwierdzenie salda|</strong>Na dzień: <strong>%DATA%|ODCINEK A" runat="server"></cc1:reportheader>
        <p>
            <em>Nadawca:</em> 
            <br />
            <ea:datalabel id="DataLabel4" runat="server" DataMember="Session.Core.Config.Firma.Pieczątka.Nazwa" DESIGNTIMEDRAGDROP="604"></ea:datalabel>
            <br />
            <ea:datalabel id="DataLabel5" runat="server" DataMember="Session.Core.Config.Firma.AdresSiedziby.Linia1"></ea:datalabel>
            <br />
            <ea:datalabel id="DataLabel6" runat="server" DataMember="Session.Core.Config.Firma.AdresSiedziby.Linia2"></ea:datalabel>
        </p>
        <p>
            <em>Odbiorca:</em><br />
            <ea:datalabel id="DataLabel1" runat="server" DataMember="NazwaFormatowana"></ea:datalabel><br />
            (<ea:DataLabel id="DataLabel7" runat="server" DataMember="Kod" Bold="False"></ea:DataLabel>)<br />
            <ea:datalabel id="DataLabel2" runat="server" DataMember="Adres.Linia1"></ea:datalabel><br />
            <ea:datalabel id="DataLabel3" runat="server" DataMember="Adres.Linia2"></ea:datalabel>
        </p>
	<p>
        Stosownie do przepisów ustawy o rachunkowości z dnia 29 września 1994 r. (Dz. U. z 2021 r. poz. 217 ze zm.) uprzejmie prosimy o potwierdzenie w terminie 30 dni zgodności sald rozliczeń
		figurujących w naszych księgach rachunkowych na dzień:&nbsp;<ea:DataLabel ID="data1" runat="server" />.<br />
		W przypadku niezgodności salda prosimy o przesłanie specyfikacji transakcji składających się na różnice.
	</p>
        <ea:DataRepeater id="DataRepeater1" runat="server" Width="100%">
            <ea:SectionMarker id="SectionMarker1" runat="server"></ea:SectionMarker>
            <p>
                <ea:grid id="Grid1" runat="server" DataMember="Pozycje" CellBorder="None" RowTypeName="Soneta.Kasa.PotwierdzenieSaldaPozycja,Soneta.Kasa">
                    <Columns>
                        <ea:GridColumn Width="25" DataMember="NumerDokumentu" Caption="Dokument" NoWrap="True"></ea:GridColumn>
                        <ea:GridColumn Width="20" DataMember="Opis" Caption="Opis" NoWrap="True"></ea:GridColumn>
                        <ea:GridColumn Align="Center" DataMember="DataDokumentu" Caption="Data"></ea:GridColumn>
                        <ea:GridColumn Align="Center" DataMember="TerminZaplaty" Caption="Termin"></ea:GridColumn>
                        <ea:GridColumn Width="12" Align="Right" DataMember="Kwota" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn Width="12" Align="Right" DataMember="Należność" Caption="Należności" HideZero="True" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn Width="12" Align="Right" DataMember="Zobowiązanie" Caption="Zobowiązania" HideZero="True" Format="{0:n}"></ea:GridColumn>
                    </Columns>
                </ea:grid>
                <table id="Table1" cellspacing="0" width="100%">
                    <tbody>
                        <tr>
                            <td align="right" width="65%">
                                Waluta: 
                                <ea:datalabel id="DataLabel16" runat="server" DataMember="Symbol"></ea:datalabel>
                            </td>
                            <td align="right">
                                <ea:Grid id="Grid5" runat="server" DataMember="Podsumowanie" ShowHeader="None">
                                    <Columns>
                                        <ea:GridColumn Width="12" DataMember="Opis"></ea:GridColumn>
                                        <ea:GridColumn Width="12" Align="Right" DataMember="Należność" Format="{0:n}"></ea:GridColumn>
                                        <ea:GridColumn Width="12" Align="Right" DataMember="Zobowiązanie" Format="{0:n}"></ea:GridColumn>
                                    </Columns>
                                </ea:Grid>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </p>
            <ea:SectionMarker id="SectionMarker3" runat="server" SectionType="Footer"></ea:SectionMarker>
        </ea:DataRepeater>
        <p>
            <cc1:ReportFooter id="ReportFooter1" runat="server" Height="105px" TheEnd="False">
                <Subtitles>
					<cc1:FooterSubtitle SubtitleType="Operator" Width="50"/>
                    <cc1:FooterSubtitle Caption="Data i podpis" Width="50"></cc1:FooterSubtitle>
                </Subtitles>
            </cc1:ReportFooter>
            <ea:SectionMarker id="SectionMarker4" runat="server" SectionType="Footer"></ea:SectionMarker>
            <ea:PageBreak id="PageBreak1" runat="server"></ea:PageBreak>
            <ea:SectionMarker id="SectionMarker5" runat="server"></ea:SectionMarker>
            <cc1:reportheader id="ReportHeader2" title="Potwierdzenie salda|</strong>Na dzień: <strong>%DATA%|ODCINEK B" runat="server"></cc1:reportheader>
        </p>
        <p>
            <em>Nadawca:</em><br />
            <ea:datalabel id="Datalabel12" runat="server" DataMember="NazwaFormatowana"></ea:datalabel><br />
            (<ea:DataLabel id="DataLabel8" runat="server" DataMember="Kod" Bold="False"></ea:DataLabel>)<br />
            <ea:datalabel id="Datalabel13" runat="server" DataMember="Adres.Linia1"></ea:datalabel><br />
            <ea:datalabel id="Datalabel14" runat="server" DataMember="Adres.Linia2"></ea:datalabel>
        </p>
        <p>
            <em>Odbiorca:</em> 
            <br />
            <ea:datalabel id="Datalabel9" runat="server" DataMember="Session.Core.Config.Firma.Pieczątka.Nazwa"></ea:datalabel>
            <br />
            <ea:datalabel id="Datalabel10" runat="server" DataMember="Session.Core.Config.Firma.AdresSiedziby.Linia1"></ea:datalabel>
            <br />
            <ea:datalabel id="Datalabel11" runat="server" DataMember="Session.Core.Config.Firma.AdresSiedziby.Linia2"></ea:datalabel>
        </p>
        <p>
		Potwierdzam zgodność niżej wyszczególnionych sald na dzień&nbsp;<ea:DataLabel ID="data2" runat="server"/>.<br />
		Saldo zgodne / saldo niezgodne z powodu:<br />
		................................................................................................................................................................<br />
		................................................................................................................................................................
	    </p>
        <ea:DataRepeater id="DataRepeater2" runat="server" Width="100%">
            <ea:SectionMarker id="SectionMarker6" runat="server"></ea:SectionMarker>
            <p>
                <ea:grid id="Grid3" runat="server" DataMember="Pozycje" CellBorder="None" RowTypeName="Soneta.Kasa.PotwierdzenieSaldaPozycja,Soneta.Kasa">
                    <Columns>
                        <ea:GridColumn Width="25" DataMember="NumerDokumentu" Caption="Dokument" NoWrap="True"></ea:GridColumn>
                        <ea:GridColumn Width="20" DataMember="Opis" Caption="Opis" NoWrap="True"></ea:GridColumn>
                        <ea:GridColumn Align="Center" DataMember="DataDokumentu" Caption="Data"></ea:GridColumn>
                        <ea:GridColumn Align="Center" DataMember="TerminZaplaty" Caption="Termin"></ea:GridColumn>
                        <ea:GridColumn Width="12" Align="Right" DataMember="Kwota" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn Width="12" Align="Right" DataMember="Zobowiązanie" Caption="Należności" HideZero="True" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn Width="12" Align="Right" DataMember="Należność" Caption="Zobowiązania" HideZero="True" Format="{0:n}"></ea:GridColumn>
                    </Columns>
                </ea:grid>
                <table id="Table2" cellspacing="0" width="100%">
                    <tbody>
                        <tr>
                            <td align="right" width="65%">
                                Waluta: 
                                <ea:datalabel id="DataLabel17" runat="server" DataMember="Symbol"></ea:datalabel>
                            </td>
                            <td align="right">
                                <ea:Grid id="Grid2" runat="server" DataMember="Podsumowanie" ShowHeader="None">
                                    <Columns>
                                        <ea:GridColumn Width="12" DataMember="Opis"></ea:GridColumn>
                                        <ea:GridColumn Width="12" Align="Right" DataMember="Zobowiązanie" Format="{0:n}"></ea:GridColumn>
                                        <ea:GridColumn Width="12" Align="Right" DataMember="Należność" Format="{0:n}"></ea:GridColumn>
                                    </Columns>
                                </ea:Grid>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </p>
            <ea:SectionMarker id="SectionMarker7" runat="server" SectionType="Footer"></ea:SectionMarker>
        </ea:DataRepeater>
        <p>
            <cc1:ReportFooter id="Reportfooter2" runat="server" Height="105px" TheEnd="False">
                <Subtitles>
                    <cc1:FooterSubtitle SubtitleType="Operator" Width="50"></cc1:FooterSubtitle>
                    <cc1:FooterSubtitle Caption="Data i podpis" Width="50"></cc1:FooterSubtitle>
                </Subtitles>
            </cc1:ReportFooter>
            <ea:SectionMarker id="SectionMarker8" runat="server" SectionType="Footer"></ea:SectionMarker>
        </p>
    </form>
</body>
</html>
